Ext.data.JsonP.sol_contract_ix_functions_CreateContractHeadless({"tagname":"class","name":"sol.contract.ix.functions.CreateContractHeadless","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.contract.ix.functions.CreateContractHeadless.js","href":"sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless"}],"eloix":true,"requires":["sol.common.IxUtils","sol.common.RepoUtils","sol.common.Template","sol.common.ix.FunctionBase","sol.contract.ix.ContractUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sordMetadata","tagname":"cfg","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"cfg-sordMetadata","meta":{"required":true}},{"name":"template","tagname":"cfg","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"cfg-template","meta":{"required":true}},{"name":"user","tagname":"cfg","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"cfg-user","meta":{"required":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildElementName","tagname":"method","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"method-buildElementName","meta":{"private":true}},{"name":"getSource","tagname":"method","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"method-getSource","meta":{"private":true}},{"name":"getUpdateWorkflow","tagname":"method","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"method-getUpdateWorkflow","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"prepareMetadata","tagname":"method","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"method-prepareMetadata","meta":{"private":true}},{"name":"prepareTemplate","tagname":"method","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"method-prepareTemplate","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.contract.ix.functions.CreateContractHeadless","id":"method-process","meta":{}}],"code_type":"ext_define","id":"class-sol.contract.ix.functions.CreateContractHeadless","short_doc":"This function can be used to create contracts without user interaction. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.contract.ix.functions.CreateContractHeadless</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.contract.ix.ContractUtils' rel='sol.contract.ix.ContractUtils' class='docClass'>sol.contract.ix.ContractUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless' target='_blank'>sol.contract.ix.functions.CreateContractHeadless.js</a></div></pre><div class='doc-contents'><p>This function can be used to create contracts without user interaction.</p>\n\n<p>The function used to create new contracts is called <code>RF_sol_contract_function_CreateContractHeadless</code> and has a defined interface.\nTo create a contract this function needs a <a href=\"#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-sordMetadata\" rel=\"sol.contract.ix.functions.CreateContractHeadless-cfg-sordMetadata\" class=\"docClass\">sordMetadata</a> object, which has to be a template sord containing the new contracts metadata.\nFurther a <a href=\"#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-template\" rel=\"sol.contract.ix.functions.CreateContractHeadless-cfg-template\" class=\"docClass\">template</a> configuration is needed to determine the template which will be used to create the new contract.</p>\n\n<h3>Examples</h3>\n\n<h3>Configuration for createing a contract</h3>\n\n<pre><code>{\n  template: { name: \"Standard contract\" },\n  sordMetadata: {\n    objKeys: {\n      CONTRACT_NAME: \"Vertragsname\",\n      CONTRACT_NO: \"C#0815\",\n      CONTRACT_RESPONSIBLE: \"Sandra Renz\",\n      CONTACT_FIRSTNAME: \"Gerd\",\n      CONTACT_LASTNAME: \"Baum\"\n    },\n    mapKeys: {\n      PARTNER_EMAIL: \"g.baum@contelo.de\"\n    }\n  }\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-sordMetadata' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-cfg-sordMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-sordMetadata' class='name expandable'>sordMetadata</a> : Object<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>A template sord containing the contract information.</p>\n</div><div class='long'><p>A template sord containing the contract information.</p>\n</div></div></div><div id='cfg-template' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-cfg-template' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-template' class='name expandable'>template</a> : Object<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>Configuration to determine the contract template. ...</div><div class='long'><p>Configuration to determine the contract template.</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>(required) Name of the contract template.</p>\n</div></li></ul></div></div></div><div id='cfg-user' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-cfg-user' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-user' class='name expandable'>user</a> : de.elo.ix.client.UserInfo<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>The user used as contract responsible (if there is no defined in sordMetadata). ...</div><div class='long'><p>The user used as contract responsible (if there is no defined in <a href=\"#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-sordMetadata\" rel=\"sol.contract.ix.functions.CreateContractHeadless-cfg-sordMetadata\" class=\"docClass\">sordMetadata</a>).\nThis user will be granted full access to the contract.\nIf calling this via the registered function, the logged in user will be used.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;user&quot;, &quot;template&quot;, &quot;sordMetadata&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildElementName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-method-buildElementName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-method-buildElementName' class='name expandable'>buildElementName</a>( <span class='pre'>contractType</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates the temporary element and workflow name. ...</div><div class='long'><p>Creates the temporary element and workflow name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contractType</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-method-getSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-method-getSource' class='name expandable'>getSource</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Prepares the datasource for the new contract ...</div><div class='long'><p>Prepares the datasource for the new contract</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getUpdateWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-method-getUpdateWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-method-getUpdateWorkflow' class='name expandable'>getUpdateWorkflow</a>( <span class='pre'></span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the headless workflow. ...</div><div class='long'><p>Retrieves the headless workflow.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-prepareMetadata' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-method-prepareMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-method-prepareMetadata' class='name expandable'>prepareMetadata</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Prepares the metadata object. ...</div><div class='long'><p>Prepares the metadata object.\nEnsures that the SOL_TYPE and the contract type is set.</p>\n</div></div></div><div id='method-prepareTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-method-prepareTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-method-prepareTemplate' class='name expandable'>prepareTemplate</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the template for the contract. ...</div><div class='long'><p>Retrieves the template for the contract.\nEnsures that the template at least has a 'name' and an 'id'</p>\n</div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.ix.functions.CreateContractHeadless'>sol.contract.ix.functions.CreateContractHeadless</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-contract-ix-functions-CreateContractHeadless-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.ix.functions.CreateContractHeadless-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates the contract. ...</div><div class='long'><p>Creates the contract.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div></div></div></div></div>","meta":{"eloix":true}});